package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class DescribeSolutionVersionRequest(solutionVersionArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeSolutionVersionRequest = {
    import DescribeSolutionVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeSolutionVersionRequest
      .builder()
      .solutionVersionArn(Arn.unwrap(solutionVersionArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.DescribeSolutionVersionRequest.ReadOnly =
    zio.aws.personalize.model.DescribeSolutionVersionRequest
      .wrap(buildAwsValue())
}
object DescribeSolutionVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeSolutionVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DescribeSolutionVersionRequest =
      zio.aws.personalize.model
        .DescribeSolutionVersionRequest(solutionVersionArn)
    def solutionVersionArn: Arn
    def getSolutionVersionArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(solutionVersionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeSolutionVersionRequest
  ) extends zio.aws.personalize.model.DescribeSolutionVersionRequest.ReadOnly {
    override val solutionVersionArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.solutionVersionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeSolutionVersionRequest
  ): zio.aws.personalize.model.DescribeSolutionVersionRequest.ReadOnly =
    new Wrapper(impl)
}
