package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeSolutionVersionResponse(
    solutionVersion: Optional[zio.aws.personalize.model.SolutionVersion] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeSolutionVersionResponse = {
    import DescribeSolutionVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeSolutionVersionResponse
      .builder()
      .optionallyWith(solutionVersion.map(value => value.buildAwsValue()))(
        _.solutionVersion
      )
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.DescribeSolutionVersionResponse.ReadOnly =
    zio.aws.personalize.model.DescribeSolutionVersionResponse
      .wrap(buildAwsValue())
}
object DescribeSolutionVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeSolutionVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DescribeSolutionVersionResponse =
      zio.aws.personalize.model.DescribeSolutionVersionResponse(
        solutionVersion.map(value => value.asEditable)
      )
    def solutionVersion
        : Optional[zio.aws.personalize.model.SolutionVersion.ReadOnly]
    def getSolutionVersion: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.SolutionVersion.ReadOnly
    ] = AwsError.unwrapOptionField("solutionVersion", solutionVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeSolutionVersionResponse
  ) extends zio.aws.personalize.model.DescribeSolutionVersionResponse.ReadOnly {
    override val solutionVersion
        : Optional[zio.aws.personalize.model.SolutionVersion.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.solutionVersion())
        .map(value => zio.aws.personalize.model.SolutionVersion.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeSolutionVersionResponse
  ): zio.aws.personalize.model.DescribeSolutionVersionResponse.ReadOnly =
    new Wrapper(impl)
}
