package zio.aws.personalize.model
import scala.jdk.CollectionConverters.*
sealed trait Domain {
  def unwrap: software.amazon.awssdk.services.personalize.model.Domain
}
object Domain {
  def wrap(
      value: software.amazon.awssdk.services.personalize.model.Domain
  ): zio.aws.personalize.model.Domain = value match {
    case software.amazon.awssdk.services.personalize.model.Domain.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.personalize.model.Domain.ECOMMERCE =>
      val r = ECOMMERCE
      r
    case software.amazon.awssdk.services.personalize.model.Domain.VIDEO_ON_DEMAND =>
      val r = VIDEO_ON_DEMAND
      r
  }
  case object unknownToSdkVersion extends zio.aws.personalize.model.Domain {
    override def unwrap
        : software.amazon.awssdk.services.personalize.model.Domain =
      software.amazon.awssdk.services.personalize.model.Domain.UNKNOWN_TO_SDK_VERSION
  }
  case object ECOMMERCE extends zio.aws.personalize.model.Domain {
    override def unwrap
        : software.amazon.awssdk.services.personalize.model.Domain =
      software.amazon.awssdk.services.personalize.model.Domain.ECOMMERCE
  }
  case object VIDEO_ON_DEMAND extends zio.aws.personalize.model.Domain {
    override def unwrap
        : software.amazon.awssdk.services.personalize.model.Domain =
      software.amazon.awssdk.services.personalize.model.Domain.VIDEO_ON_DEMAND
  }
}
