package zio.aws.personalize.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.personalize.model.primitives.{
  Status,
  Date,
  FailureReason,
  Arn,
  Name
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class FilterSummary(
    name: Optional[Name] = Optional.Absent,
    filterArn: Optional[Arn] = Optional.Absent,
    creationDateTime: Optional[Date] = Optional.Absent,
    lastUpdatedDateTime: Optional[Date] = Optional.Absent,
    datasetGroupArn: Optional[Arn] = Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent,
    status: Optional[Status] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.FilterSummary = {
    import FilterSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.FilterSummary
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        filterArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.filterArn)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(
        datasetGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetGroupArn)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.FilterSummary.ReadOnly =
    zio.aws.personalize.model.FilterSummary.wrap(buildAwsValue())
}
object FilterSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.FilterSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.FilterSummary =
      zio.aws.personalize.model.FilterSummary(
        name.map(value => value),
        filterArn.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        datasetGroupArn.map(value => value),
        failureReason.map(value => value),
        status.map(value => value)
      )
    def name: Optional[Name]
    def filterArn: Optional[Arn]
    def creationDateTime: Optional[Date]
    def lastUpdatedDateTime: Optional[Date]
    def datasetGroupArn: Optional[Arn]
    def failureReason: Optional[FailureReason]
    def status: Optional[Status]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getFilterArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("filterArn", filterArn)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getDatasetGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetGroupArn", datasetGroupArn)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.FilterSummary
  ) extends zio.aws.personalize.model.FilterSummary.ReadOnly {
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val filterArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.filterArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val creationDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val datasetGroupArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetGroupArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.personalize.model.primitives.FailureReason(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.FilterSummary
  ): zio.aws.personalize.model.FilterSummary.ReadOnly = new Wrapper(impl)
}
