package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class HPOConfig(
    hpoObjective: Optional[zio.aws.personalize.model.HPOObjective] =
      Optional.Absent,
    hpoResourceConfig: Optional[zio.aws.personalize.model.HPOResourceConfig] =
      Optional.Absent,
    algorithmHyperParameterRanges: Optional[
      zio.aws.personalize.model.HyperParameterRanges
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.HPOConfig = {
    import HPOConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.HPOConfig
      .builder()
      .optionallyWith(hpoObjective.map(value => value.buildAwsValue()))(
        _.hpoObjective
      )
      .optionallyWith(hpoResourceConfig.map(value => value.buildAwsValue()))(
        _.hpoResourceConfig
      )
      .optionallyWith(
        algorithmHyperParameterRanges.map(value => value.buildAwsValue())
      )(_.algorithmHyperParameterRanges)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.HPOConfig.ReadOnly =
    zio.aws.personalize.model.HPOConfig.wrap(buildAwsValue())
}
object HPOConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.HPOConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.HPOConfig =
      zio.aws.personalize.model.HPOConfig(
        hpoObjective.map(value => value.asEditable),
        hpoResourceConfig.map(value => value.asEditable),
        algorithmHyperParameterRanges.map(value => value.asEditable)
      )
    def hpoObjective: Optional[zio.aws.personalize.model.HPOObjective.ReadOnly]
    def hpoResourceConfig
        : Optional[zio.aws.personalize.model.HPOResourceConfig.ReadOnly]
    def algorithmHyperParameterRanges
        : Optional[zio.aws.personalize.model.HyperParameterRanges.ReadOnly]
    def getHpoObjective
        : ZIO[Any, AwsError, zio.aws.personalize.model.HPOObjective.ReadOnly] =
      AwsError.unwrapOptionField("hpoObjective", hpoObjective)
    def getHpoResourceConfig: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.HPOResourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField("hpoResourceConfig", hpoResourceConfig)
    def getAlgorithmHyperParameterRanges: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.HyperParameterRanges.ReadOnly
    ] = AwsError.unwrapOptionField(
      "algorithmHyperParameterRanges",
      algorithmHyperParameterRanges
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.HPOConfig
  ) extends zio.aws.personalize.model.HPOConfig.ReadOnly {
    override val hpoObjective
        : Optional[zio.aws.personalize.model.HPOObjective.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hpoObjective())
        .map(value => zio.aws.personalize.model.HPOObjective.wrap(value))
    override val hpoResourceConfig
        : Optional[zio.aws.personalize.model.HPOResourceConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hpoResourceConfig())
        .map(value => zio.aws.personalize.model.HPOResourceConfig.wrap(value))
    override val algorithmHyperParameterRanges
        : Optional[zio.aws.personalize.model.HyperParameterRanges.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.algorithmHyperParameterRanges())
        .map(value =>
          zio.aws.personalize.model.HyperParameterRanges.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.HPOConfig
  ): zio.aws.personalize.model.HPOConfig.ReadOnly = new Wrapper(impl)
}
