package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class HyperParameterRanges(
    integerHyperParameterRanges: Optional[
      Iterable[zio.aws.personalize.model.IntegerHyperParameterRange]
    ] = Optional.Absent,
    continuousHyperParameterRanges: Optional[
      Iterable[zio.aws.personalize.model.ContinuousHyperParameterRange]
    ] = Optional.Absent,
    categoricalHyperParameterRanges: Optional[
      Iterable[zio.aws.personalize.model.CategoricalHyperParameterRange]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.HyperParameterRanges = {
    import HyperParameterRanges.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.HyperParameterRanges
      .builder()
      .optionallyWith(
        integerHyperParameterRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.integerHyperParameterRanges)
      .optionallyWith(
        continuousHyperParameterRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.continuousHyperParameterRanges)
      .optionallyWith(
        categoricalHyperParameterRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.categoricalHyperParameterRanges)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.HyperParameterRanges.ReadOnly =
    zio.aws.personalize.model.HyperParameterRanges.wrap(buildAwsValue())
}
object HyperParameterRanges {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.HyperParameterRanges
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.HyperParameterRanges =
      zio.aws.personalize.model.HyperParameterRanges(
        integerHyperParameterRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        continuousHyperParameterRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        categoricalHyperParameterRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def integerHyperParameterRanges: Optional[
      List[zio.aws.personalize.model.IntegerHyperParameterRange.ReadOnly]
    ]
    def continuousHyperParameterRanges: Optional[
      List[zio.aws.personalize.model.ContinuousHyperParameterRange.ReadOnly]
    ]
    def categoricalHyperParameterRanges: Optional[
      List[zio.aws.personalize.model.CategoricalHyperParameterRange.ReadOnly]
    ]
    def getIntegerHyperParameterRanges: ZIO[Any, AwsError, List[
      zio.aws.personalize.model.IntegerHyperParameterRange.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "integerHyperParameterRanges",
      integerHyperParameterRanges
    )
    def getContinuousHyperParameterRanges: ZIO[Any, AwsError, List[
      zio.aws.personalize.model.ContinuousHyperParameterRange.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "continuousHyperParameterRanges",
      continuousHyperParameterRanges
    )
    def getCategoricalHyperParameterRanges: ZIO[Any, AwsError, List[
      zio.aws.personalize.model.CategoricalHyperParameterRange.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "categoricalHyperParameterRanges",
      categoricalHyperParameterRanges
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.HyperParameterRanges
  ) extends zio.aws.personalize.model.HyperParameterRanges.ReadOnly {
    override val integerHyperParameterRanges: Optional[
      List[zio.aws.personalize.model.IntegerHyperParameterRange.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.integerHyperParameterRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.personalize.model.IntegerHyperParameterRange.wrap(item)
        }.toList
      )
    override val continuousHyperParameterRanges: Optional[
      List[zio.aws.personalize.model.ContinuousHyperParameterRange.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.continuousHyperParameterRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.personalize.model.ContinuousHyperParameterRange.wrap(item)
        }.toList
      )
    override val categoricalHyperParameterRanges: Optional[
      List[zio.aws.personalize.model.CategoricalHyperParameterRange.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.categoricalHyperParameterRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.personalize.model.CategoricalHyperParameterRange.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.HyperParameterRanges
  ): zio.aws.personalize.model.HyperParameterRanges.ReadOnly = new Wrapper(impl)
}
