package zio.aws.personalize.model
import scala.jdk.CollectionConverters.*
sealed trait ImportMode {
  def unwrap: software.amazon.awssdk.services.personalize.model.ImportMode
}
object ImportMode {
  def wrap(
      value: software.amazon.awssdk.services.personalize.model.ImportMode
  ): zio.aws.personalize.model.ImportMode = value match {
    case software.amazon.awssdk.services.personalize.model.ImportMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.personalize.model.ImportMode.FULL =>
      val r = FULL
      r
    case software.amazon.awssdk.services.personalize.model.ImportMode.INCREMENTAL =>
      val r = INCREMENTAL
      r
  }
  case object unknownToSdkVersion extends zio.aws.personalize.model.ImportMode {
    override def unwrap
        : software.amazon.awssdk.services.personalize.model.ImportMode =
      software.amazon.awssdk.services.personalize.model.ImportMode.UNKNOWN_TO_SDK_VERSION
  }
  case object FULL extends zio.aws.personalize.model.ImportMode {
    override def unwrap
        : software.amazon.awssdk.services.personalize.model.ImportMode =
      software.amazon.awssdk.services.personalize.model.ImportMode.FULL
  }
  case object INCREMENTAL extends zio.aws.personalize.model.ImportMode {
    override def unwrap
        : software.amazon.awssdk.services.personalize.model.ImportMode =
      software.amazon.awssdk.services.personalize.model.ImportMode.INCREMENTAL
  }
}
