package zio.aws.personalize.model
import zio.prelude.data.Optional
import zio.aws.personalize.model.primitives.{MaxResults, NextToken, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListCampaignsRequest(
    solutionArn: Optional[Arn] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.ListCampaignsRequest = {
    import ListCampaignsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.ListCampaignsRequest
      .builder()
      .optionallyWith(
        solutionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.solutionArn)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.ListCampaignsRequest.ReadOnly =
    zio.aws.personalize.model.ListCampaignsRequest.wrap(buildAwsValue())
}
object ListCampaignsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.ListCampaignsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.ListCampaignsRequest =
      zio.aws.personalize.model.ListCampaignsRequest(
        solutionArn.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def solutionArn: Optional[Arn]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getSolutionArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("solutionArn", solutionArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.ListCampaignsRequest
  ) extends zio.aws.personalize.model.ListCampaignsRequest.ReadOnly {
    override val solutionArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.solutionArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.personalize.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.personalize.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.ListCampaignsRequest
  ): zio.aws.personalize.model.ListCampaignsRequest.ReadOnly = new Wrapper(impl)
}
