package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDatasetGroupsResponse(
    datasetGroups: Optional[
      Iterable[zio.aws.personalize.model.DatasetGroupSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.ListDatasetGroupsResponse = {
    import ListDatasetGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.ListDatasetGroupsResponse
      .builder()
      .optionallyWith(
        datasetGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.datasetGroups)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.ListDatasetGroupsResponse.ReadOnly =
    zio.aws.personalize.model.ListDatasetGroupsResponse.wrap(buildAwsValue())
}
object ListDatasetGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.ListDatasetGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.ListDatasetGroupsResponse =
      zio.aws.personalize.model.ListDatasetGroupsResponse(
        datasetGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def datasetGroups
        : Optional[List[zio.aws.personalize.model.DatasetGroupSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getDatasetGroups: ZIO[Any, AwsError, List[
      zio.aws.personalize.model.DatasetGroupSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("datasetGroups", datasetGroups)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.ListDatasetGroupsResponse
  ) extends zio.aws.personalize.model.ListDatasetGroupsResponse.ReadOnly {
    override val datasetGroups: Optional[
      List[zio.aws.personalize.model.DatasetGroupSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.personalize.model.DatasetGroupSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.personalize.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.ListDatasetGroupsResponse
  ): zio.aws.personalize.model.ListDatasetGroupsResponse.ReadOnly = new Wrapper(
    impl
  )
}
