package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListEventTrackersResponse(
    eventTrackers: Optional[
      Iterable[zio.aws.personalize.model.EventTrackerSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.ListEventTrackersResponse = {
    import ListEventTrackersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.ListEventTrackersResponse
      .builder()
      .optionallyWith(
        eventTrackers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventTrackers)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.ListEventTrackersResponse.ReadOnly =
    zio.aws.personalize.model.ListEventTrackersResponse.wrap(buildAwsValue())
}
object ListEventTrackersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.ListEventTrackersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.ListEventTrackersResponse =
      zio.aws.personalize.model.ListEventTrackersResponse(
        eventTrackers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def eventTrackers
        : Optional[List[zio.aws.personalize.model.EventTrackerSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getEventTrackers: ZIO[Any, AwsError, List[
      zio.aws.personalize.model.EventTrackerSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("eventTrackers", eventTrackers)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.ListEventTrackersResponse
  ) extends zio.aws.personalize.model.ListEventTrackersResponse.ReadOnly {
    override val eventTrackers: Optional[
      List[zio.aws.personalize.model.EventTrackerSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.eventTrackers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.personalize.model.EventTrackerSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.personalize.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.ListEventTrackersResponse
  ): zio.aws.personalize.model.ListEventTrackersResponse.ReadOnly = new Wrapper(
    impl
  )
}
