package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListSchemasResponse(
    schemas: Optional[
      Iterable[zio.aws.personalize.model.DatasetSchemaSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.ListSchemasResponse = {
    import ListSchemasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.ListSchemasResponse
      .builder()
      .optionallyWith(
        schemas.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.schemas)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.ListSchemasResponse.ReadOnly =
    zio.aws.personalize.model.ListSchemasResponse.wrap(buildAwsValue())
}
object ListSchemasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.ListSchemasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.ListSchemasResponse =
      zio.aws.personalize.model.ListSchemasResponse(
        schemas.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def schemas: Optional[
      List[zio.aws.personalize.model.DatasetSchemaSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getSchemas: ZIO[Any, AwsError, List[
      zio.aws.personalize.model.DatasetSchemaSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("schemas", schemas)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.ListSchemasResponse
  ) extends zio.aws.personalize.model.ListSchemasResponse.ReadOnly {
    override val schemas: Optional[
      List[zio.aws.personalize.model.DatasetSchemaSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.schemas())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.personalize.model.DatasetSchemaSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.personalize.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.ListSchemasResponse
  ): zio.aws.personalize.model.ListSchemasResponse.ReadOnly = new Wrapper(impl)
}
