package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListSolutionVersionsResponse(
    solutionVersions: Optional[
      Iterable[zio.aws.personalize.model.SolutionVersionSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.ListSolutionVersionsResponse = {
    import ListSolutionVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.ListSolutionVersionsResponse
      .builder()
      .optionallyWith(
        solutionVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.solutionVersions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.ListSolutionVersionsResponse.ReadOnly =
    zio.aws.personalize.model.ListSolutionVersionsResponse.wrap(buildAwsValue())
}
object ListSolutionVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.ListSolutionVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.ListSolutionVersionsResponse =
      zio.aws.personalize.model.ListSolutionVersionsResponse(
        solutionVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def solutionVersions: Optional[
      List[zio.aws.personalize.model.SolutionVersionSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getSolutionVersions: ZIO[Any, AwsError, List[
      zio.aws.personalize.model.SolutionVersionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("solutionVersions", solutionVersions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.ListSolutionVersionsResponse
  ) extends zio.aws.personalize.model.ListSolutionVersionsResponse.ReadOnly {
    override val solutionVersions: Optional[
      List[zio.aws.personalize.model.SolutionVersionSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.solutionVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.personalize.model.SolutionVersionSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.personalize.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.ListSolutionVersionsResponse
  ): zio.aws.personalize.model.ListSolutionVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
