package zio.aws.personalize.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.personalize.model.primitives.{Date, Status, Arn, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class RecipeSummary(
    name: Optional[Name] = Optional.Absent,
    recipeArn: Optional[Arn] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    creationDateTime: Optional[Date] = Optional.Absent,
    lastUpdatedDateTime: Optional[Date] = Optional.Absent,
    domain: Optional[zio.aws.personalize.model.Domain] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.RecipeSummary = {
    import RecipeSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.RecipeSummary
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        recipeArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.recipeArn)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(domain.map(value => value.unwrap))(_.domain)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.RecipeSummary.ReadOnly =
    zio.aws.personalize.model.RecipeSummary.wrap(buildAwsValue())
}
object RecipeSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.RecipeSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.RecipeSummary =
      zio.aws.personalize.model.RecipeSummary(
        name.map(value => value),
        recipeArn.map(value => value),
        status.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        domain.map(value => value)
      )
    def name: Optional[Name]
    def recipeArn: Optional[Arn]
    def status: Optional[Status]
    def creationDateTime: Optional[Date]
    def lastUpdatedDateTime: Optional[Date]
    def domain: Optional[zio.aws.personalize.model.Domain]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getRecipeArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("recipeArn", recipeArn)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getDomain: ZIO[Any, AwsError, zio.aws.personalize.model.Domain] =
      AwsError.unwrapOptionField("domain", domain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.RecipeSummary
  ) extends zio.aws.personalize.model.RecipeSummary.ReadOnly {
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val recipeArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.recipeArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val creationDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val domain: Optional[zio.aws.personalize.model.Domain] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domain())
        .map(value => zio.aws.personalize.model.Domain.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.RecipeSummary
  ): zio.aws.personalize.model.RecipeSummary.ReadOnly = new Wrapper(impl)
}
