package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{KmsKeyArn, S3Location}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class S3DataConfig(
    path: S3Location,
    kmsKeyArn: Optional[KmsKeyArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.S3DataConfig = {
    import S3DataConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.S3DataConfig
      .builder()
      .path(S3Location.unwrap(path): java.lang.String)
      .optionallyWith(
        kmsKeyArn.map(value => KmsKeyArn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.S3DataConfig.ReadOnly =
    zio.aws.personalize.model.S3DataConfig.wrap(buildAwsValue())
}
object S3DataConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.S3DataConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.S3DataConfig =
      zio.aws.personalize.model
        .S3DataConfig(path, kmsKeyArn.map(value => value))
    def path: S3Location
    def kmsKeyArn: Optional[KmsKeyArn]
    def getPath: ZIO[Any, Nothing, S3Location] = ZIO.succeed(path)
    def getKmsKeyArn: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.S3DataConfig
  ) extends zio.aws.personalize.model.S3DataConfig.ReadOnly {
    override val path: S3Location =
      zio.aws.personalize.model.primitives.S3Location(impl.path())
    override val kmsKeyArn: Optional[KmsKeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => zio.aws.personalize.model.primitives.KmsKeyArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.S3DataConfig
  ): zio.aws.personalize.model.S3DataConfig.ReadOnly = new Wrapper(impl)
}
