package zio.aws.personalize.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.personalize.model.primitives.{
  PerformAutoML,
  Status,
  Date,
  Arn,
  EventType,
  PerformHPO,
  Name
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Solution(
    name: Optional[Name] = Optional.Absent,
    solutionArn: Optional[Arn] = Optional.Absent,
    performHPO: Optional[PerformHPO] = Optional.Absent,
    performAutoML: Optional[PerformAutoML] = Optional.Absent,
    recipeArn: Optional[Arn] = Optional.Absent,
    datasetGroupArn: Optional[Arn] = Optional.Absent,
    eventType: Optional[EventType] = Optional.Absent,
    solutionConfig: Optional[zio.aws.personalize.model.SolutionConfig] =
      Optional.Absent,
    autoMLResult: Optional[zio.aws.personalize.model.AutoMLResult] =
      Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    creationDateTime: Optional[Date] = Optional.Absent,
    lastUpdatedDateTime: Optional[Date] = Optional.Absent,
    latestSolutionVersion: Optional[
      zio.aws.personalize.model.SolutionVersionSummary
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.Solution = {
    import Solution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.Solution
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        solutionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.solutionArn)
      .optionallyWith(
        performHPO.map(value => PerformHPO.unwrap(value): java.lang.Boolean)
      )(_.performHPO)
      .optionallyWith(
        performAutoML.map(value =>
          PerformAutoML.unwrap(value): java.lang.Boolean
        )
      )(_.performAutoML)
      .optionallyWith(
        recipeArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.recipeArn)
      .optionallyWith(
        datasetGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetGroupArn)
      .optionallyWith(
        eventType.map(value => EventType.unwrap(value): java.lang.String)
      )(_.eventType)
      .optionallyWith(solutionConfig.map(value => value.buildAwsValue()))(
        _.solutionConfig
      )
      .optionallyWith(autoMLResult.map(value => value.buildAwsValue()))(
        _.autoMLResult
      )
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(
        latestSolutionVersion.map(value => value.buildAwsValue())
      )(_.latestSolutionVersion)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.Solution.ReadOnly =
    zio.aws.personalize.model.Solution.wrap(buildAwsValue())
}
object Solution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.Solution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.Solution =
      zio.aws.personalize.model.Solution(
        name.map(value => value),
        solutionArn.map(value => value),
        performHPO.map(value => value),
        performAutoML.map(value => value),
        recipeArn.map(value => value),
        datasetGroupArn.map(value => value),
        eventType.map(value => value),
        solutionConfig.map(value => value.asEditable),
        autoMLResult.map(value => value.asEditable),
        status.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        latestSolutionVersion.map(value => value.asEditable)
      )
    def name: Optional[Name]
    def solutionArn: Optional[Arn]
    def performHPO: Optional[PerformHPO]
    def performAutoML: Optional[PerformAutoML]
    def recipeArn: Optional[Arn]
    def datasetGroupArn: Optional[Arn]
    def eventType: Optional[EventType]
    def solutionConfig
        : Optional[zio.aws.personalize.model.SolutionConfig.ReadOnly]
    def autoMLResult: Optional[zio.aws.personalize.model.AutoMLResult.ReadOnly]
    def status: Optional[Status]
    def creationDateTime: Optional[Date]
    def lastUpdatedDateTime: Optional[Date]
    def latestSolutionVersion
        : Optional[zio.aws.personalize.model.SolutionVersionSummary.ReadOnly]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getSolutionArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("solutionArn", solutionArn)
    def getPerformHPO: ZIO[Any, AwsError, PerformHPO] =
      AwsError.unwrapOptionField("performHPO", performHPO)
    def getPerformAutoML: ZIO[Any, AwsError, PerformAutoML] =
      AwsError.unwrapOptionField("performAutoML", performAutoML)
    def getRecipeArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("recipeArn", recipeArn)
    def getDatasetGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetGroupArn", datasetGroupArn)
    def getEventType: ZIO[Any, AwsError, EventType] =
      AwsError.unwrapOptionField("eventType", eventType)
    def getSolutionConfig: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.SolutionConfig.ReadOnly
    ] = AwsError.unwrapOptionField("solutionConfig", solutionConfig)
    def getAutoMLResult
        : ZIO[Any, AwsError, zio.aws.personalize.model.AutoMLResult.ReadOnly] =
      AwsError.unwrapOptionField("autoMLResult", autoMLResult)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getLatestSolutionVersion: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.SolutionVersionSummary.ReadOnly
    ] =
      AwsError.unwrapOptionField("latestSolutionVersion", latestSolutionVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.Solution
  ) extends zio.aws.personalize.model.Solution.ReadOnly {
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val solutionArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.solutionArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val performHPO: Optional[PerformHPO] = zio.aws.core.internal
      .optionalFromNullable(impl.performHPO())
      .map(value => zio.aws.personalize.model.primitives.PerformHPO(value))
    override val performAutoML: Optional[PerformAutoML] = zio.aws.core.internal
      .optionalFromNullable(impl.performAutoML())
      .map(value => zio.aws.personalize.model.primitives.PerformAutoML(value))
    override val recipeArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.recipeArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val datasetGroupArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetGroupArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val eventType: Optional[EventType] = zio.aws.core.internal
      .optionalFromNullable(impl.eventType())
      .map(value => zio.aws.personalize.model.primitives.EventType(value))
    override val solutionConfig
        : Optional[zio.aws.personalize.model.SolutionConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.solutionConfig())
        .map(value => zio.aws.personalize.model.SolutionConfig.wrap(value))
    override val autoMLResult
        : Optional[zio.aws.personalize.model.AutoMLResult.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMLResult())
        .map(value => zio.aws.personalize.model.AutoMLResult.wrap(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val creationDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val latestSolutionVersion
        : Optional[zio.aws.personalize.model.SolutionVersionSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestSolutionVersion())
        .map(value =>
          zio.aws.personalize.model.SolutionVersionSummary.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.Solution
  ): zio.aws.personalize.model.Solution.ReadOnly = new Wrapper(impl)
}
