package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.{TagValue, TagKey}
import scala.jdk.CollectionConverters.*
final case class Tag(tagKey: TagKey, tagValue: TagValue) {
  def buildAwsValue(): software.amazon.awssdk.services.personalize.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.Tag
      .builder()
      .tagKey(TagKey.unwrap(tagKey): java.lang.String)
      .tagValue(TagValue.unwrap(tagValue): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.Tag.ReadOnly =
    zio.aws.personalize.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.personalize.model.Tag] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.Tag =
      zio.aws.personalize.model.Tag(tagKey, tagValue)
    def tagKey: TagKey
    def tagValue: TagValue
    def getTagKey: ZIO[Any, Nothing, TagKey] = ZIO.succeed(tagKey)
    def getTagValue: ZIO[Any, Nothing, TagValue] = ZIO.succeed(tagValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.Tag
  ) extends zio.aws.personalize.model.Tag.ReadOnly {
    override val tagKey: TagKey =
      zio.aws.personalize.model.primitives.TagKey(impl.tagKey())
    override val tagValue: TagValue =
      zio.aws.personalize.model.primitives.TagValue(impl.tagValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.Tag
  ): zio.aws.personalize.model.Tag.ReadOnly = new Wrapper(impl)
}
