package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceArn: Arn,
    tags: Iterable[zio.aws.personalize.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.TagResourceRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.TagResourceRequest.ReadOnly =
    zio.aws.personalize.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.TagResourceRequest =
      zio.aws.personalize.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: Arn
    def tags: List[zio.aws.personalize.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.personalize.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.TagResourceRequest
  ) extends zio.aws.personalize.model.TagResourceRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.resourceArn())
    override val tags: List[zio.aws.personalize.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.personalize.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.TagResourceRequest
  ): zio.aws.personalize.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
