package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.Arn
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateRecommenderResponse(
    recommenderArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.UpdateRecommenderResponse = {
    import UpdateRecommenderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.UpdateRecommenderResponse
      .builder()
      .optionallyWith(
        recommenderArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.recommenderArn)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.UpdateRecommenderResponse.ReadOnly =
    zio.aws.personalize.model.UpdateRecommenderResponse.wrap(buildAwsValue())
}
object UpdateRecommenderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.UpdateRecommenderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.UpdateRecommenderResponse =
      zio.aws.personalize.model
        .UpdateRecommenderResponse(recommenderArn.map(value => value))
    def recommenderArn: Optional[Arn]
    def getRecommenderArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("recommenderArn", recommenderArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.UpdateRecommenderResponse
  ) extends zio.aws.personalize.model.UpdateRecommenderResponse.ReadOnly {
    override val recommenderArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.recommenderArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.UpdateRecommenderResponse
  ): zio.aws.personalize.model.UpdateRecommenderResponse.ReadOnly = new Wrapper(
    impl
  )
}
