package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchSegmentJobOutput(
    s3DataDestination: zio.aws.personalize.model.S3DataConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.BatchSegmentJobOutput = {
    import BatchSegmentJobOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.BatchSegmentJobOutput
      .builder()
      .s3DataDestination(s3DataDestination.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.BatchSegmentJobOutput.ReadOnly =
    zio.aws.personalize.model.BatchSegmentJobOutput.wrap(buildAwsValue())
}
object BatchSegmentJobOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.BatchSegmentJobOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.BatchSegmentJobOutput =
      zio.aws.personalize.model
        .BatchSegmentJobOutput(s3DataDestination.asEditable)
    def s3DataDestination: zio.aws.personalize.model.S3DataConfig.ReadOnly
    def getS3DataDestination
        : ZIO[Any, Nothing, zio.aws.personalize.model.S3DataConfig.ReadOnly] =
      ZIO.succeed(s3DataDestination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.BatchSegmentJobOutput
  ) extends zio.aws.personalize.model.BatchSegmentJobOutput.ReadOnly {
    override val s3DataDestination
        : zio.aws.personalize.model.S3DataConfig.ReadOnly =
      zio.aws.personalize.model.S3DataConfig.wrap(impl.s3DataDestination())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.BatchSegmentJobOutput
  ): zio.aws.personalize.model.BatchSegmentJobOutput.ReadOnly = new Wrapper(
    impl
  )
}
