package zio.aws.personalize.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.personalize.model.primitives.{
  Status,
  Date,
  FailureReason,
  Arn,
  Name
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class BatchSegmentJobSummary(
    batchSegmentJobArn: Optional[Arn] = Optional.Absent,
    jobName: Optional[Name] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    creationDateTime: Optional[Date] = Optional.Absent,
    lastUpdatedDateTime: Optional[Date] = Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent,
    solutionVersionArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.BatchSegmentJobSummary = {
    import BatchSegmentJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.BatchSegmentJobSummary
      .builder()
      .optionallyWith(
        batchSegmentJobArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.batchSegmentJobArn)
      .optionallyWith(
        jobName.map(value => Name.unwrap(value): java.lang.String)
      )(_.jobName)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        solutionVersionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.solutionVersionArn)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.BatchSegmentJobSummary.ReadOnly =
    zio.aws.personalize.model.BatchSegmentJobSummary.wrap(buildAwsValue())
}
object BatchSegmentJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.BatchSegmentJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.BatchSegmentJobSummary =
      zio.aws.personalize.model.BatchSegmentJobSummary(
        batchSegmentJobArn.map(value => value),
        jobName.map(value => value),
        status.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        failureReason.map(value => value),
        solutionVersionArn.map(value => value)
      )
    def batchSegmentJobArn: Optional[Arn]
    def jobName: Optional[Name]
    def status: Optional[Status]
    def creationDateTime: Optional[Date]
    def lastUpdatedDateTime: Optional[Date]
    def failureReason: Optional[FailureReason]
    def solutionVersionArn: Optional[Arn]
    def getBatchSegmentJobArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("batchSegmentJobArn", batchSegmentJobArn)
    def getJobName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getSolutionVersionArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("solutionVersionArn", solutionVersionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.BatchSegmentJobSummary
  ) extends zio.aws.personalize.model.BatchSegmentJobSummary.ReadOnly {
    override val batchSegmentJobArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.batchSegmentJobArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val jobName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.jobName())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val creationDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.personalize.model.primitives.FailureReason(value))
    override val solutionVersionArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.solutionVersionArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.BatchSegmentJobSummary
  ): zio.aws.personalize.model.BatchSegmentJobSummary.ReadOnly = new Wrapper(
    impl
  )
}
