package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{ParameterValue, ParameterName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CampaignConfig(
    itemExplorationConfig: Optional[Map[ParameterName, ParameterValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CampaignConfig = {
    import CampaignConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CampaignConfig
      .builder()
      .optionallyWith(
        itemExplorationConfig.map(value =>
          value
            .map({ case (key, value) =>
              (ParameterName.unwrap(key): java.lang.String) -> (ParameterValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.itemExplorationConfig)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.CampaignConfig.ReadOnly =
    zio.aws.personalize.model.CampaignConfig.wrap(buildAwsValue())
}
object CampaignConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CampaignConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CampaignConfig =
      zio.aws.personalize.model
        .CampaignConfig(itemExplorationConfig.map(value => value))
    def itemExplorationConfig: Optional[Map[ParameterName, ParameterValue]]
    def getItemExplorationConfig
        : ZIO[Any, AwsError, Map[ParameterName, ParameterValue]] =
      AwsError.unwrapOptionField("itemExplorationConfig", itemExplorationConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CampaignConfig
  ) extends zio.aws.personalize.model.CampaignConfig.ReadOnly {
    override val itemExplorationConfig
        : Optional[Map[ParameterName, ParameterValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.itemExplorationConfig())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.personalize.model.primitives.ParameterName(
              key
            ) -> zio.aws.personalize.model.primitives.ParameterValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CampaignConfig
  ): zio.aws.personalize.model.CampaignConfig.ReadOnly = new Wrapper(impl)
}
