package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.Arn
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDatasetImportJobResponse(
    datasetImportJobArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateDatasetImportJobResponse = {
    import CreateDatasetImportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateDatasetImportJobResponse
      .builder()
      .optionallyWith(
        datasetImportJobArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetImportJobArn)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.CreateDatasetImportJobResponse.ReadOnly =
    zio.aws.personalize.model.CreateDatasetImportJobResponse
      .wrap(buildAwsValue())
}
object CreateDatasetImportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateDatasetImportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateDatasetImportJobResponse =
      zio.aws.personalize.model
        .CreateDatasetImportJobResponse(datasetImportJobArn.map(value => value))
    def datasetImportJobArn: Optional[Arn]
    def getDatasetImportJobArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetImportJobArn", datasetImportJobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateDatasetImportJobResponse
  ) extends zio.aws.personalize.model.CreateDatasetImportJobResponse.ReadOnly {
    override val datasetImportJobArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetImportJobArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateDatasetImportJobResponse
  ): zio.aws.personalize.model.CreateDatasetImportJobResponse.ReadOnly =
    new Wrapper(impl)
}
