package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.Arn
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateFilterResponse(
    filterArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateFilterResponse = {
    import CreateFilterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateFilterResponse
      .builder()
      .optionallyWith(
        filterArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.filterArn)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.CreateFilterResponse.ReadOnly =
    zio.aws.personalize.model.CreateFilterResponse.wrap(buildAwsValue())
}
object CreateFilterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateFilterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateFilterResponse =
      zio.aws.personalize.model
        .CreateFilterResponse(filterArn.map(value => value))
    def filterArn: Optional[Arn]
    def getFilterArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("filterArn", filterArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateFilterResponse
  ) extends zio.aws.personalize.model.CreateFilterResponse.ReadOnly {
    override val filterArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.filterArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateFilterResponse
  ): zio.aws.personalize.model.CreateFilterResponse.ReadOnly = new Wrapper(impl)
}
