package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.{Arn, Name}
import scala.jdk.CollectionConverters.*
final case class CreateMetricAttributionRequest(
    name: Name,
    datasetGroupArn: Arn,
    metrics: Iterable[zio.aws.personalize.model.MetricAttribute],
    metricsOutputConfig: zio.aws.personalize.model.MetricAttributionOutput
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateMetricAttributionRequest = {
    import CreateMetricAttributionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateMetricAttributionRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .datasetGroupArn(Arn.unwrap(datasetGroupArn): java.lang.String)
      .metrics(metrics.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .metricsOutputConfig(metricsOutputConfig.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.CreateMetricAttributionRequest.ReadOnly =
    zio.aws.personalize.model.CreateMetricAttributionRequest
      .wrap(buildAwsValue())
}
object CreateMetricAttributionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateMetricAttributionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateMetricAttributionRequest =
      zio.aws.personalize.model.CreateMetricAttributionRequest(
        name,
        datasetGroupArn,
        metrics.map { item =>
          item.asEditable
        },
        metricsOutputConfig.asEditable
      )
    def name: Name
    def datasetGroupArn: Arn
    def metrics: List[zio.aws.personalize.model.MetricAttribute.ReadOnly]
    def metricsOutputConfig
        : zio.aws.personalize.model.MetricAttributionOutput.ReadOnly
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDatasetGroupArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(datasetGroupArn)
    def getMetrics: ZIO[Any, Nothing, List[
      zio.aws.personalize.model.MetricAttribute.ReadOnly
    ]] = ZIO.succeed(metrics)
    def getMetricsOutputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.personalize.model.MetricAttributionOutput.ReadOnly
    ] = ZIO.succeed(metricsOutputConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateMetricAttributionRequest
  ) extends zio.aws.personalize.model.CreateMetricAttributionRequest.ReadOnly {
    override val name: Name =
      zio.aws.personalize.model.primitives.Name(impl.name())
    override val datasetGroupArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.datasetGroupArn())
    override val metrics
        : List[zio.aws.personalize.model.MetricAttribute.ReadOnly] = impl
      .metrics()
      .asScala
      .map { item =>
        zio.aws.personalize.model.MetricAttribute.wrap(item)
      }
      .toList
    override val metricsOutputConfig
        : zio.aws.personalize.model.MetricAttributionOutput.ReadOnly =
      zio.aws.personalize.model.MetricAttributionOutput
        .wrap(impl.metricsOutputConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateMetricAttributionRequest
  ): zio.aws.personalize.model.CreateMetricAttributionRequest.ReadOnly =
    new Wrapper(impl)
}
