package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.Arn
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateMetricAttributionResponse(
    metricAttributionArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateMetricAttributionResponse = {
    import CreateMetricAttributionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateMetricAttributionResponse
      .builder()
      .optionallyWith(
        metricAttributionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.metricAttributionArn)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.CreateMetricAttributionResponse.ReadOnly =
    zio.aws.personalize.model.CreateMetricAttributionResponse
      .wrap(buildAwsValue())
}
object CreateMetricAttributionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateMetricAttributionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateMetricAttributionResponse =
      zio.aws.personalize.model.CreateMetricAttributionResponse(
        metricAttributionArn.map(value => value)
      )
    def metricAttributionArn: Optional[Arn]
    def getMetricAttributionArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("metricAttributionArn", metricAttributionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateMetricAttributionResponse
  ) extends zio.aws.personalize.model.CreateMetricAttributionResponse.ReadOnly {
    override val metricAttributionArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.metricAttributionArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateMetricAttributionResponse
  ): zio.aws.personalize.model.CreateMetricAttributionResponse.ReadOnly =
    new Wrapper(impl)
}
