package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{Arn, Name}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateSolutionVersionRequest(
    name: Optional[Name] = Optional.Absent,
    solutionArn: Arn,
    trainingMode: Optional[zio.aws.personalize.model.TrainingMode] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.personalize.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.CreateSolutionVersionRequest = {
    import CreateSolutionVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.CreateSolutionVersionRequest
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .solutionArn(Arn.unwrap(solutionArn): java.lang.String)
      .optionallyWith(trainingMode.map(value => value.unwrap))(_.trainingMode)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.CreateSolutionVersionRequest.ReadOnly =
    zio.aws.personalize.model.CreateSolutionVersionRequest.wrap(buildAwsValue())
}
object CreateSolutionVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.CreateSolutionVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.CreateSolutionVersionRequest =
      zio.aws.personalize.model.CreateSolutionVersionRequest(
        name.map(value => value),
        solutionArn,
        trainingMode.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Optional[Name]
    def solutionArn: Arn
    def trainingMode: Optional[zio.aws.personalize.model.TrainingMode]
    def tags: Optional[List[zio.aws.personalize.model.Tag.ReadOnly]]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getSolutionArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(solutionArn)
    def getTrainingMode
        : ZIO[Any, AwsError, zio.aws.personalize.model.TrainingMode] =
      AwsError.unwrapOptionField("trainingMode", trainingMode)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.personalize.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.CreateSolutionVersionRequest
  ) extends zio.aws.personalize.model.CreateSolutionVersionRequest.ReadOnly {
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val solutionArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.solutionArn())
    override val trainingMode
        : Optional[zio.aws.personalize.model.TrainingMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trainingMode())
        .map(value => zio.aws.personalize.model.TrainingMode.wrap(value))
    override val tags: Optional[List[zio.aws.personalize.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.personalize.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.CreateSolutionVersionRequest
  ): zio.aws.personalize.model.CreateSolutionVersionRequest.ReadOnly =
    new Wrapper(impl)
}
