package zio.aws.personalize.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.personalize.model.primitives.{
  Status,
  Date,
  Arn,
  DatasetType,
  Name
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Dataset(
    name: Optional[Name] = Optional.Absent,
    datasetArn: Optional[Arn] = Optional.Absent,
    datasetGroupArn: Optional[Arn] = Optional.Absent,
    datasetType: Optional[DatasetType] = Optional.Absent,
    schemaArn: Optional[Arn] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    creationDateTime: Optional[Date] = Optional.Absent,
    lastUpdatedDateTime: Optional[Date] = Optional.Absent,
    latestDatasetUpdate: Optional[
      zio.aws.personalize.model.DatasetUpdateSummary
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.Dataset = {
    import Dataset.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.Dataset
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        datasetArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .optionallyWith(
        datasetGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetGroupArn)
      .optionallyWith(
        datasetType.map(value => DatasetType.unwrap(value): java.lang.String)
      )(_.datasetType)
      .optionallyWith(
        schemaArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.schemaArn)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(latestDatasetUpdate.map(value => value.buildAwsValue()))(
        _.latestDatasetUpdate
      )
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.Dataset.ReadOnly =
    zio.aws.personalize.model.Dataset.wrap(buildAwsValue())
}
object Dataset {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.Dataset
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.Dataset =
      zio.aws.personalize.model.Dataset(
        name.map(value => value),
        datasetArn.map(value => value),
        datasetGroupArn.map(value => value),
        datasetType.map(value => value),
        schemaArn.map(value => value),
        status.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        latestDatasetUpdate.map(value => value.asEditable)
      )
    def name: Optional[Name]
    def datasetArn: Optional[Arn]
    def datasetGroupArn: Optional[Arn]
    def datasetType: Optional[DatasetType]
    def schemaArn: Optional[Arn]
    def status: Optional[Status]
    def creationDateTime: Optional[Date]
    def lastUpdatedDateTime: Optional[Date]
    def latestDatasetUpdate
        : Optional[zio.aws.personalize.model.DatasetUpdateSummary.ReadOnly]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDatasetArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
    def getDatasetGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetGroupArn", datasetGroupArn)
    def getDatasetType: ZIO[Any, AwsError, DatasetType] =
      AwsError.unwrapOptionField("datasetType", datasetType)
    def getSchemaArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("schemaArn", schemaArn)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getLatestDatasetUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.DatasetUpdateSummary.ReadOnly
    ] = AwsError.unwrapOptionField("latestDatasetUpdate", latestDatasetUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.Dataset
  ) extends zio.aws.personalize.model.Dataset.ReadOnly {
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val datasetArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val datasetGroupArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetGroupArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val datasetType: Optional[DatasetType] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetType())
      .map(value => zio.aws.personalize.model.primitives.DatasetType(value))
    override val schemaArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val creationDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val latestDatasetUpdate
        : Optional[zio.aws.personalize.model.DatasetUpdateSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestDatasetUpdate())
        .map(value =>
          zio.aws.personalize.model.DatasetUpdateSummary.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.Dataset
  ): zio.aws.personalize.model.Dataset.ReadOnly = new Wrapper(impl)
}
