package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DatasetExportJobOutput(
    s3DataDestination: zio.aws.personalize.model.S3DataConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DatasetExportJobOutput = {
    import DatasetExportJobOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DatasetExportJobOutput
      .builder()
      .s3DataDestination(s3DataDestination.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DatasetExportJobOutput.ReadOnly =
    zio.aws.personalize.model.DatasetExportJobOutput.wrap(buildAwsValue())
}
object DatasetExportJobOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DatasetExportJobOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DatasetExportJobOutput =
      zio.aws.personalize.model
        .DatasetExportJobOutput(s3DataDestination.asEditable)
    def s3DataDestination: zio.aws.personalize.model.S3DataConfig.ReadOnly
    def getS3DataDestination
        : ZIO[Any, Nothing, zio.aws.personalize.model.S3DataConfig.ReadOnly] =
      ZIO.succeed(s3DataDestination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DatasetExportJobOutput
  ) extends zio.aws.personalize.model.DatasetExportJobOutput.ReadOnly {
    override val s3DataDestination
        : zio.aws.personalize.model.S3DataConfig.ReadOnly =
      zio.aws.personalize.model.S3DataConfig.wrap(impl.s3DataDestination())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DatasetExportJobOutput
  ): zio.aws.personalize.model.DatasetExportJobOutput.ReadOnly = new Wrapper(
    impl
  )
}
