package zio.aws.personalize.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.personalize.model.primitives.{
  Status,
  Date,
  FailureReason,
  Arn,
  Name
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DatasetImportJob(
    jobName: Optional[Name] = Optional.Absent,
    datasetImportJobArn: Optional[Arn] = Optional.Absent,
    datasetArn: Optional[Arn] = Optional.Absent,
    dataSource: Optional[zio.aws.personalize.model.DataSource] =
      Optional.Absent,
    roleArn: Optional[Arn] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    creationDateTime: Optional[Date] = Optional.Absent,
    lastUpdatedDateTime: Optional[Date] = Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent,
    importMode: Optional[zio.aws.personalize.model.ImportMode] =
      Optional.Absent,
    publishAttributionMetricsToS3: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DatasetImportJob = {
    import DatasetImportJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DatasetImportJob
      .builder()
      .optionallyWith(
        jobName.map(value => Name.unwrap(value): java.lang.String)
      )(_.jobName)
      .optionallyWith(
        datasetImportJobArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetImportJobArn)
      .optionallyWith(
        datasetArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .optionallyWith(dataSource.map(value => value.buildAwsValue()))(
        _.dataSource
      )
      .optionallyWith(
        roleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(importMode.map(value => value.unwrap))(_.importMode)
      .optionallyWith(
        publishAttributionMetricsToS3.map(value => value: java.lang.Boolean)
      )(_.publishAttributionMetricsToS3)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DatasetImportJob.ReadOnly =
    zio.aws.personalize.model.DatasetImportJob.wrap(buildAwsValue())
}
object DatasetImportJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DatasetImportJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DatasetImportJob =
      zio.aws.personalize.model.DatasetImportJob(
        jobName.map(value => value),
        datasetImportJobArn.map(value => value),
        datasetArn.map(value => value),
        dataSource.map(value => value.asEditable),
        roleArn.map(value => value),
        status.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        failureReason.map(value => value),
        importMode.map(value => value),
        publishAttributionMetricsToS3.map(value => value)
      )
    def jobName: Optional[Name]
    def datasetImportJobArn: Optional[Arn]
    def datasetArn: Optional[Arn]
    def dataSource: Optional[zio.aws.personalize.model.DataSource.ReadOnly]
    def roleArn: Optional[Arn]
    def status: Optional[Status]
    def creationDateTime: Optional[Date]
    def lastUpdatedDateTime: Optional[Date]
    def failureReason: Optional[FailureReason]
    def importMode: Optional[zio.aws.personalize.model.ImportMode]
    def publishAttributionMetricsToS3: Optional[Boolean]
    def getJobName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getDatasetImportJobArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetImportJobArn", datasetImportJobArn)
    def getDatasetArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
    def getDataSource
        : ZIO[Any, AwsError, zio.aws.personalize.model.DataSource.ReadOnly] =
      AwsError.unwrapOptionField("dataSource", dataSource)
    def getRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getImportMode
        : ZIO[Any, AwsError, zio.aws.personalize.model.ImportMode] =
      AwsError.unwrapOptionField("importMode", importMode)
    def getPublishAttributionMetricsToS3: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "publishAttributionMetricsToS3",
        publishAttributionMetricsToS3
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DatasetImportJob
  ) extends zio.aws.personalize.model.DatasetImportJob.ReadOnly {
    override val jobName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.jobName())
      .map(value => zio.aws.personalize.model.primitives.Name(value))
    override val datasetImportJobArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetImportJobArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val datasetArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val dataSource
        : Optional[zio.aws.personalize.model.DataSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSource())
        .map(value => zio.aws.personalize.model.DataSource.wrap(value))
    override val roleArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val creationDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.personalize.model.primitives.FailureReason(value))
    override val importMode: Optional[zio.aws.personalize.model.ImportMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importMode())
        .map(value => zio.aws.personalize.model.ImportMode.wrap(value))
    override val publishAttributionMetricsToS3: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publishAttributionMetricsToS3())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DatasetImportJob
  ): zio.aws.personalize.model.DatasetImportJob.ReadOnly = new Wrapper(impl)
}
