package zio.aws.personalize.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.personalize.model.primitives.{Date, FailureReason, Status, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DatasetUpdateSummary(
    schemaArn: Optional[Arn] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent,
    creationDateTime: Optional[Date] = Optional.Absent,
    lastUpdatedDateTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DatasetUpdateSummary = {
    import DatasetUpdateSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DatasetUpdateSummary
      .builder()
      .optionallyWith(
        schemaArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.schemaArn)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DatasetUpdateSummary.ReadOnly =
    zio.aws.personalize.model.DatasetUpdateSummary.wrap(buildAwsValue())
}
object DatasetUpdateSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DatasetUpdateSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DatasetUpdateSummary =
      zio.aws.personalize.model.DatasetUpdateSummary(
        schemaArn.map(value => value),
        status.map(value => value),
        failureReason.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value)
      )
    def schemaArn: Optional[Arn]
    def status: Optional[Status]
    def failureReason: Optional[FailureReason]
    def creationDateTime: Optional[Date]
    def lastUpdatedDateTime: Optional[Date]
    def getSchemaArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("schemaArn", schemaArn)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DatasetUpdateSummary
  ) extends zio.aws.personalize.model.DatasetUpdateSummary.ReadOnly {
    override val schemaArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.personalize.model.primitives.Status(value))
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.personalize.model.primitives.FailureReason(value))
    override val creationDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
    override val lastUpdatedDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedDateTime())
      .map(value => zio.aws.personalize.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DatasetUpdateSummary
  ): zio.aws.personalize.model.DatasetUpdateSummary.ReadOnly = new Wrapper(impl)
}
