package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DefaultHyperParameterRanges(
    integerHyperParameterRanges: Optional[
      Iterable[zio.aws.personalize.model.DefaultIntegerHyperParameterRange]
    ] = Optional.Absent,
    continuousHyperParameterRanges: Optional[
      Iterable[zio.aws.personalize.model.DefaultContinuousHyperParameterRange]
    ] = Optional.Absent,
    categoricalHyperParameterRanges: Optional[
      Iterable[zio.aws.personalize.model.DefaultCategoricalHyperParameterRange]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DefaultHyperParameterRanges = {
    import DefaultHyperParameterRanges.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DefaultHyperParameterRanges
      .builder()
      .optionallyWith(
        integerHyperParameterRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.integerHyperParameterRanges)
      .optionallyWith(
        continuousHyperParameterRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.continuousHyperParameterRanges)
      .optionallyWith(
        categoricalHyperParameterRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.categoricalHyperParameterRanges)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.DefaultHyperParameterRanges.ReadOnly =
    zio.aws.personalize.model.DefaultHyperParameterRanges.wrap(buildAwsValue())
}
object DefaultHyperParameterRanges {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DefaultHyperParameterRanges
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DefaultHyperParameterRanges =
      zio.aws.personalize.model.DefaultHyperParameterRanges(
        integerHyperParameterRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        continuousHyperParameterRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        categoricalHyperParameterRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def integerHyperParameterRanges: Optional[
      List[zio.aws.personalize.model.DefaultIntegerHyperParameterRange.ReadOnly]
    ]
    def continuousHyperParameterRanges: Optional[List[
      zio.aws.personalize.model.DefaultContinuousHyperParameterRange.ReadOnly
    ]]
    def categoricalHyperParameterRanges: Optional[List[
      zio.aws.personalize.model.DefaultCategoricalHyperParameterRange.ReadOnly
    ]]
    def getIntegerHyperParameterRanges: ZIO[Any, AwsError, List[
      zio.aws.personalize.model.DefaultIntegerHyperParameterRange.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "integerHyperParameterRanges",
      integerHyperParameterRanges
    )
    def getContinuousHyperParameterRanges: ZIO[Any, AwsError, List[
      zio.aws.personalize.model.DefaultContinuousHyperParameterRange.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "continuousHyperParameterRanges",
      continuousHyperParameterRanges
    )
    def getCategoricalHyperParameterRanges: ZIO[Any, AwsError, List[
      zio.aws.personalize.model.DefaultCategoricalHyperParameterRange.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "categoricalHyperParameterRanges",
      categoricalHyperParameterRanges
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DefaultHyperParameterRanges
  ) extends zio.aws.personalize.model.DefaultHyperParameterRanges.ReadOnly {
    override val integerHyperParameterRanges: Optional[
      List[zio.aws.personalize.model.DefaultIntegerHyperParameterRange.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.integerHyperParameterRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.personalize.model.DefaultIntegerHyperParameterRange.wrap(item)
        }.toList
      )
    override val continuousHyperParameterRanges: Optional[List[
      zio.aws.personalize.model.DefaultContinuousHyperParameterRange.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.continuousHyperParameterRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.personalize.model.DefaultContinuousHyperParameterRange
            .wrap(item)
        }.toList
      )
    override val categoricalHyperParameterRanges: Optional[List[
      zio.aws.personalize.model.DefaultCategoricalHyperParameterRange.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.categoricalHyperParameterRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.personalize.model.DefaultCategoricalHyperParameterRange
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DefaultHyperParameterRanges
  ): zio.aws.personalize.model.DefaultHyperParameterRanges.ReadOnly =
    new Wrapper(impl)
}
