package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class DeleteMetricAttributionRequest(metricAttributionArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DeleteMetricAttributionRequest = {
    import DeleteMetricAttributionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DeleteMetricAttributionRequest
      .builder()
      .metricAttributionArn(Arn.unwrap(metricAttributionArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.DeleteMetricAttributionRequest.ReadOnly =
    zio.aws.personalize.model.DeleteMetricAttributionRequest
      .wrap(buildAwsValue())
}
object DeleteMetricAttributionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DeleteMetricAttributionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DeleteMetricAttributionRequest =
      zio.aws.personalize.model
        .DeleteMetricAttributionRequest(metricAttributionArn)
    def metricAttributionArn: Arn
    def getMetricAttributionArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(metricAttributionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DeleteMetricAttributionRequest
  ) extends zio.aws.personalize.model.DeleteMetricAttributionRequest.ReadOnly {
    override val metricAttributionArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.metricAttributionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DeleteMetricAttributionRequest
  ): zio.aws.personalize.model.DeleteMetricAttributionRequest.ReadOnly =
    new Wrapper(impl)
}
