package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class DeleteRecommenderRequest(recommenderArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DeleteRecommenderRequest = {
    import DeleteRecommenderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DeleteRecommenderRequest
      .builder()
      .recommenderArn(Arn.unwrap(recommenderArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DeleteRecommenderRequest.ReadOnly =
    zio.aws.personalize.model.DeleteRecommenderRequest.wrap(buildAwsValue())
}
object DeleteRecommenderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DeleteRecommenderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DeleteRecommenderRequest =
      zio.aws.personalize.model.DeleteRecommenderRequest(recommenderArn)
    def recommenderArn: Arn
    def getRecommenderArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(recommenderArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DeleteRecommenderRequest
  ) extends zio.aws.personalize.model.DeleteRecommenderRequest.ReadOnly {
    override val recommenderArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.recommenderArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DeleteRecommenderRequest
  ): zio.aws.personalize.model.DeleteRecommenderRequest.ReadOnly = new Wrapper(
    impl
  )
}
