package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class DeleteSchemaRequest(schemaArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DeleteSchemaRequest = {
    import DeleteSchemaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DeleteSchemaRequest
      .builder()
      .schemaArn(Arn.unwrap(schemaArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DeleteSchemaRequest.ReadOnly =
    zio.aws.personalize.model.DeleteSchemaRequest.wrap(buildAwsValue())
}
object DeleteSchemaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DeleteSchemaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DeleteSchemaRequest =
      zio.aws.personalize.model.DeleteSchemaRequest(schemaArn)
    def schemaArn: Arn
    def getSchemaArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(schemaArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DeleteSchemaRequest
  ) extends zio.aws.personalize.model.DeleteSchemaRequest.ReadOnly {
    override val schemaArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.schemaArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DeleteSchemaRequest
  ): zio.aws.personalize.model.DeleteSchemaRequest.ReadOnly = new Wrapper(impl)
}
