package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class DeleteSolutionRequest(solutionArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DeleteSolutionRequest = {
    import DeleteSolutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DeleteSolutionRequest
      .builder()
      .solutionArn(Arn.unwrap(solutionArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DeleteSolutionRequest.ReadOnly =
    zio.aws.personalize.model.DeleteSolutionRequest.wrap(buildAwsValue())
}
object DeleteSolutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DeleteSolutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DeleteSolutionRequest =
      zio.aws.personalize.model.DeleteSolutionRequest(solutionArn)
    def solutionArn: Arn
    def getSolutionArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(solutionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DeleteSolutionRequest
  ) extends zio.aws.personalize.model.DeleteSolutionRequest.ReadOnly {
    override val solutionArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.solutionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DeleteSolutionRequest
  ): zio.aws.personalize.model.DeleteSolutionRequest.ReadOnly = new Wrapper(
    impl
  )
}
