package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeAlgorithmResponse(
    algorithm: Optional[zio.aws.personalize.model.Algorithm] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeAlgorithmResponse = {
    import DescribeAlgorithmResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeAlgorithmResponse
      .builder()
      .optionallyWith(algorithm.map(value => value.buildAwsValue()))(
        _.algorithm
      )
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DescribeAlgorithmResponse.ReadOnly =
    zio.aws.personalize.model.DescribeAlgorithmResponse.wrap(buildAwsValue())
}
object DescribeAlgorithmResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeAlgorithmResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DescribeAlgorithmResponse =
      zio.aws.personalize.model
        .DescribeAlgorithmResponse(algorithm.map(value => value.asEditable))
    def algorithm: Optional[zio.aws.personalize.model.Algorithm.ReadOnly]
    def getAlgorithm
        : ZIO[Any, AwsError, zio.aws.personalize.model.Algorithm.ReadOnly] =
      AwsError.unwrapOptionField("algorithm", algorithm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeAlgorithmResponse
  ) extends zio.aws.personalize.model.DescribeAlgorithmResponse.ReadOnly {
    override val algorithm
        : Optional[zio.aws.personalize.model.Algorithm.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.algorithm())
        .map(value => zio.aws.personalize.model.Algorithm.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeAlgorithmResponse
  ): zio.aws.personalize.model.DescribeAlgorithmResponse.ReadOnly = new Wrapper(
    impl
  )
}
