package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class DescribeBatchSegmentJobRequest(batchSegmentJobArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeBatchSegmentJobRequest = {
    import DescribeBatchSegmentJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeBatchSegmentJobRequest
      .builder()
      .batchSegmentJobArn(Arn.unwrap(batchSegmentJobArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.DescribeBatchSegmentJobRequest.ReadOnly =
    zio.aws.personalize.model.DescribeBatchSegmentJobRequest
      .wrap(buildAwsValue())
}
object DescribeBatchSegmentJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeBatchSegmentJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DescribeBatchSegmentJobRequest =
      zio.aws.personalize.model
        .DescribeBatchSegmentJobRequest(batchSegmentJobArn)
    def batchSegmentJobArn: Arn
    def getBatchSegmentJobArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(batchSegmentJobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeBatchSegmentJobRequest
  ) extends zio.aws.personalize.model.DescribeBatchSegmentJobRequest.ReadOnly {
    override val batchSegmentJobArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.batchSegmentJobArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeBatchSegmentJobRequest
  ): zio.aws.personalize.model.DescribeBatchSegmentJobRequest.ReadOnly =
    new Wrapper(impl)
}
