package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class DescribeDatasetImportJobRequest(datasetImportJobArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeDatasetImportJobRequest = {
    import DescribeDatasetImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeDatasetImportJobRequest
      .builder()
      .datasetImportJobArn(Arn.unwrap(datasetImportJobArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.DescribeDatasetImportJobRequest.ReadOnly =
    zio.aws.personalize.model.DescribeDatasetImportJobRequest
      .wrap(buildAwsValue())
}
object DescribeDatasetImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeDatasetImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DescribeDatasetImportJobRequest =
      zio.aws.personalize.model
        .DescribeDatasetImportJobRequest(datasetImportJobArn)
    def datasetImportJobArn: Arn
    def getDatasetImportJobArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(datasetImportJobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeDatasetImportJobRequest
  ) extends zio.aws.personalize.model.DescribeDatasetImportJobRequest.ReadOnly {
    override val datasetImportJobArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.datasetImportJobArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeDatasetImportJobRequest
  ): zio.aws.personalize.model.DescribeDatasetImportJobRequest.ReadOnly =
    new Wrapper(impl)
}
