package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeDatasetImportJobResponse(
    datasetImportJob: Optional[zio.aws.personalize.model.DatasetImportJob] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeDatasetImportJobResponse = {
    import DescribeDatasetImportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeDatasetImportJobResponse
      .builder()
      .optionallyWith(datasetImportJob.map(value => value.buildAwsValue()))(
        _.datasetImportJob
      )
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.DescribeDatasetImportJobResponse.ReadOnly =
    zio.aws.personalize.model.DescribeDatasetImportJobResponse
      .wrap(buildAwsValue())
}
object DescribeDatasetImportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeDatasetImportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DescribeDatasetImportJobResponse =
      zio.aws.personalize.model.DescribeDatasetImportJobResponse(
        datasetImportJob.map(value => value.asEditable)
      )
    def datasetImportJob
        : Optional[zio.aws.personalize.model.DatasetImportJob.ReadOnly]
    def getDatasetImportJob: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.DatasetImportJob.ReadOnly
    ] = AwsError.unwrapOptionField("datasetImportJob", datasetImportJob)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeDatasetImportJobResponse
  ) extends zio.aws.personalize.model.DescribeDatasetImportJobResponse.ReadOnly {
    override val datasetImportJob
        : Optional[zio.aws.personalize.model.DatasetImportJob.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasetImportJob())
        .map(value => zio.aws.personalize.model.DatasetImportJob.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeDatasetImportJobResponse
  ): zio.aws.personalize.model.DescribeDatasetImportJobResponse.ReadOnly =
    new Wrapper(impl)
}
