package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeEventTrackerResponse(
    eventTracker: Optional[zio.aws.personalize.model.EventTracker] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeEventTrackerResponse = {
    import DescribeEventTrackerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeEventTrackerResponse
      .builder()
      .optionallyWith(eventTracker.map(value => value.buildAwsValue()))(
        _.eventTracker
      )
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.DescribeEventTrackerResponse.ReadOnly =
    zio.aws.personalize.model.DescribeEventTrackerResponse.wrap(buildAwsValue())
}
object DescribeEventTrackerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeEventTrackerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DescribeEventTrackerResponse =
      zio.aws.personalize.model.DescribeEventTrackerResponse(
        eventTracker.map(value => value.asEditable)
      )
    def eventTracker: Optional[zio.aws.personalize.model.EventTracker.ReadOnly]
    def getEventTracker
        : ZIO[Any, AwsError, zio.aws.personalize.model.EventTracker.ReadOnly] =
      AwsError.unwrapOptionField("eventTracker", eventTracker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeEventTrackerResponse
  ) extends zio.aws.personalize.model.DescribeEventTrackerResponse.ReadOnly {
    override val eventTracker
        : Optional[zio.aws.personalize.model.EventTracker.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventTracker())
        .map(value => zio.aws.personalize.model.EventTracker.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeEventTrackerResponse
  ): zio.aws.personalize.model.DescribeEventTrackerResponse.ReadOnly =
    new Wrapper(impl)
}
