package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class DescribeFeatureTransformationRequest(
    featureTransformationArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeFeatureTransformationRequest = {
    import DescribeFeatureTransformationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeFeatureTransformationRequest
      .builder()
      .featureTransformationArn(
        Arn.unwrap(featureTransformationArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.DescribeFeatureTransformationRequest.ReadOnly =
    zio.aws.personalize.model.DescribeFeatureTransformationRequest
      .wrap(buildAwsValue())
}
object DescribeFeatureTransformationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeFeatureTransformationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.personalize.model.DescribeFeatureTransformationRequest =
      zio.aws.personalize.model
        .DescribeFeatureTransformationRequest(featureTransformationArn)
    def featureTransformationArn: Arn
    def getFeatureTransformationArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(featureTransformationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeFeatureTransformationRequest
  ) extends zio.aws.personalize.model.DescribeFeatureTransformationRequest.ReadOnly {
    override val featureTransformationArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.featureTransformationArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeFeatureTransformationRequest
  ): zio.aws.personalize.model.DescribeFeatureTransformationRequest.ReadOnly =
    new Wrapper(impl)
}
