package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeFeatureTransformationResponse(
    featureTransformation: Optional[
      zio.aws.personalize.model.FeatureTransformation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeFeatureTransformationResponse = {
    import DescribeFeatureTransformationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeFeatureTransformationResponse
      .builder()
      .optionallyWith(
        featureTransformation.map(value => value.buildAwsValue())
      )(_.featureTransformation)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.DescribeFeatureTransformationResponse.ReadOnly =
    zio.aws.personalize.model.DescribeFeatureTransformationResponse
      .wrap(buildAwsValue())
}
object DescribeFeatureTransformationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeFeatureTransformationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.personalize.model.DescribeFeatureTransformationResponse =
      zio.aws.personalize.model.DescribeFeatureTransformationResponse(
        featureTransformation.map(value => value.asEditable)
      )
    def featureTransformation
        : Optional[zio.aws.personalize.model.FeatureTransformation.ReadOnly]
    def getFeatureTransformation: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.FeatureTransformation.ReadOnly
    ] =
      AwsError.unwrapOptionField("featureTransformation", featureTransformation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeFeatureTransformationResponse
  ) extends zio.aws.personalize.model.DescribeFeatureTransformationResponse.ReadOnly {
    override val featureTransformation
        : Optional[zio.aws.personalize.model.FeatureTransformation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureTransformation())
        .map(value =>
          zio.aws.personalize.model.FeatureTransformation.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeFeatureTransformationResponse
  ): zio.aws.personalize.model.DescribeFeatureTransformationResponse.ReadOnly =
    new Wrapper(impl)
}
