package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class DescribeFilterRequest(filterArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeFilterRequest = {
    import DescribeFilterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeFilterRequest
      .builder()
      .filterArn(Arn.unwrap(filterArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DescribeFilterRequest.ReadOnly =
    zio.aws.personalize.model.DescribeFilterRequest.wrap(buildAwsValue())
}
object DescribeFilterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeFilterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DescribeFilterRequest =
      zio.aws.personalize.model.DescribeFilterRequest(filterArn)
    def filterArn: Arn
    def getFilterArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(filterArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeFilterRequest
  ) extends zio.aws.personalize.model.DescribeFilterRequest.ReadOnly {
    override val filterArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.filterArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeFilterRequest
  ): zio.aws.personalize.model.DescribeFilterRequest.ReadOnly = new Wrapper(
    impl
  )
}
