package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class DescribeMetricAttributionRequest(metricAttributionArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeMetricAttributionRequest = {
    import DescribeMetricAttributionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeMetricAttributionRequest
      .builder()
      .metricAttributionArn(Arn.unwrap(metricAttributionArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.DescribeMetricAttributionRequest.ReadOnly =
    zio.aws.personalize.model.DescribeMetricAttributionRequest
      .wrap(buildAwsValue())
}
object DescribeMetricAttributionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeMetricAttributionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DescribeMetricAttributionRequest =
      zio.aws.personalize.model
        .DescribeMetricAttributionRequest(metricAttributionArn)
    def metricAttributionArn: Arn
    def getMetricAttributionArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(metricAttributionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeMetricAttributionRequest
  ) extends zio.aws.personalize.model.DescribeMetricAttributionRequest.ReadOnly {
    override val metricAttributionArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.metricAttributionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeMetricAttributionRequest
  ): zio.aws.personalize.model.DescribeMetricAttributionRequest.ReadOnly =
    new Wrapper(impl)
}
