package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeMetricAttributionResponse(
    metricAttribution: Optional[zio.aws.personalize.model.MetricAttribution] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeMetricAttributionResponse = {
    import DescribeMetricAttributionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeMetricAttributionResponse
      .builder()
      .optionallyWith(metricAttribution.map(value => value.buildAwsValue()))(
        _.metricAttribution
      )
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.DescribeMetricAttributionResponse.ReadOnly =
    zio.aws.personalize.model.DescribeMetricAttributionResponse
      .wrap(buildAwsValue())
}
object DescribeMetricAttributionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeMetricAttributionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.personalize.model.DescribeMetricAttributionResponse =
      zio.aws.personalize.model.DescribeMetricAttributionResponse(
        metricAttribution.map(value => value.asEditable)
      )
    def metricAttribution
        : Optional[zio.aws.personalize.model.MetricAttribution.ReadOnly]
    def getMetricAttribution: ZIO[
      Any,
      AwsError,
      zio.aws.personalize.model.MetricAttribution.ReadOnly
    ] = AwsError.unwrapOptionField("metricAttribution", metricAttribution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeMetricAttributionResponse
  ) extends zio.aws.personalize.model.DescribeMetricAttributionResponse.ReadOnly {
    override val metricAttribution
        : Optional[zio.aws.personalize.model.MetricAttribution.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricAttribution())
        .map(value => zio.aws.personalize.model.MetricAttribution.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeMetricAttributionResponse
  ): zio.aws.personalize.model.DescribeMetricAttributionResponse.ReadOnly =
    new Wrapper(impl)
}
