package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalize.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class DescribeSolutionRequest(solutionArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeSolutionRequest = {
    import DescribeSolutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeSolutionRequest
      .builder()
      .solutionArn(Arn.unwrap(solutionArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DescribeSolutionRequest.ReadOnly =
    zio.aws.personalize.model.DescribeSolutionRequest.wrap(buildAwsValue())
}
object DescribeSolutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeSolutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DescribeSolutionRequest =
      zio.aws.personalize.model.DescribeSolutionRequest(solutionArn)
    def solutionArn: Arn
    def getSolutionArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(solutionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeSolutionRequest
  ) extends zio.aws.personalize.model.DescribeSolutionRequest.ReadOnly {
    override val solutionArn: Arn =
      zio.aws.personalize.model.primitives.Arn(impl.solutionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeSolutionRequest
  ): zio.aws.personalize.model.DescribeSolutionRequest.ReadOnly = new Wrapper(
    impl
  )
}
