package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeSolutionResponse(
    solution: Optional[zio.aws.personalize.model.Solution] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.DescribeSolutionResponse = {
    import DescribeSolutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.DescribeSolutionResponse
      .builder()
      .optionallyWith(solution.map(value => value.buildAwsValue()))(_.solution)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.DescribeSolutionResponse.ReadOnly =
    zio.aws.personalize.model.DescribeSolutionResponse.wrap(buildAwsValue())
}
object DescribeSolutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.DescribeSolutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.DescribeSolutionResponse =
      zio.aws.personalize.model
        .DescribeSolutionResponse(solution.map(value => value.asEditable))
    def solution: Optional[zio.aws.personalize.model.Solution.ReadOnly]
    def getSolution
        : ZIO[Any, AwsError, zio.aws.personalize.model.Solution.ReadOnly] =
      AwsError.unwrapOptionField("solution", solution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.DescribeSolutionResponse
  ) extends zio.aws.personalize.model.DescribeSolutionResponse.ReadOnly {
    override val solution
        : Optional[zio.aws.personalize.model.Solution.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.solution())
        .map(value => zio.aws.personalize.model.Solution.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.DescribeSolutionResponse
  ): zio.aws.personalize.model.DescribeSolutionResponse.ReadOnly = new Wrapper(
    impl
  )
}
