package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.{
  MetricRegex,
  MetricName,
  HPOObjectiveType
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class HPOObjective(
    `type`: Optional[HPOObjectiveType] = Optional.Absent,
    metricName: Optional[MetricName] = Optional.Absent,
    metricRegex: Optional[MetricRegex] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.HPOObjective = {
    import HPOObjective.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.HPOObjective
      .builder()
      .optionallyWith(
        `type`.map(value => HPOObjectiveType.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        metricName.map(value => MetricName.unwrap(value): java.lang.String)
      )(_.metricName)
      .optionallyWith(
        metricRegex.map(value => MetricRegex.unwrap(value): java.lang.String)
      )(_.metricRegex)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.HPOObjective.ReadOnly =
    zio.aws.personalize.model.HPOObjective.wrap(buildAwsValue())
}
object HPOObjective {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.HPOObjective
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.HPOObjective =
      zio.aws.personalize.model.HPOObjective(
        `type`.map(value => value),
        metricName.map(value => value),
        metricRegex.map(value => value)
      )
    def `type`: Optional[HPOObjectiveType]
    def metricName: Optional[MetricName]
    def metricRegex: Optional[MetricRegex]
    def getType: ZIO[Any, AwsError, HPOObjectiveType] =
      AwsError.unwrapOptionField("type", `type`)
    def getMetricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getMetricRegex: ZIO[Any, AwsError, MetricRegex] =
      AwsError.unwrapOptionField("metricRegex", metricRegex)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.HPOObjective
  ) extends zio.aws.personalize.model.HPOObjective.ReadOnly {
    override val `type`: Optional[HPOObjectiveType] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value =>
        zio.aws.personalize.model.primitives.HPOObjectiveType(value)
      )
    override val metricName: Optional[MetricName] = zio.aws.core.internal
      .optionalFromNullable(impl.metricName())
      .map(value => zio.aws.personalize.model.primitives.MetricName(value))
    override val metricRegex: Optional[MetricRegex] = zio.aws.core.internal
      .optionalFromNullable(impl.metricRegex())
      .map(value => zio.aws.personalize.model.primitives.MetricRegex(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.HPOObjective
  ): zio.aws.personalize.model.HPOObjective.ReadOnly = new Wrapper(impl)
}
