package zio.aws.personalize.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalize.model.primitives.HPOResource
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class HPOResourceConfig(
    maxNumberOfTrainingJobs: Optional[HPOResource] = Optional.Absent,
    maxParallelTrainingJobs: Optional[HPOResource] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.HPOResourceConfig = {
    import HPOResourceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.HPOResourceConfig
      .builder()
      .optionallyWith(
        maxNumberOfTrainingJobs.map(value =>
          HPOResource.unwrap(value): java.lang.String
        )
      )(_.maxNumberOfTrainingJobs)
      .optionallyWith(
        maxParallelTrainingJobs.map(value =>
          HPOResource.unwrap(value): java.lang.String
        )
      )(_.maxParallelTrainingJobs)
      .build()
  }
  def asReadOnly: zio.aws.personalize.model.HPOResourceConfig.ReadOnly =
    zio.aws.personalize.model.HPOResourceConfig.wrap(buildAwsValue())
}
object HPOResourceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.HPOResourceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.HPOResourceConfig =
      zio.aws.personalize.model.HPOResourceConfig(
        maxNumberOfTrainingJobs.map(value => value),
        maxParallelTrainingJobs.map(value => value)
      )
    def maxNumberOfTrainingJobs: Optional[HPOResource]
    def maxParallelTrainingJobs: Optional[HPOResource]
    def getMaxNumberOfTrainingJobs: ZIO[Any, AwsError, HPOResource] = AwsError
      .unwrapOptionField("maxNumberOfTrainingJobs", maxNumberOfTrainingJobs)
    def getMaxParallelTrainingJobs: ZIO[Any, AwsError, HPOResource] = AwsError
      .unwrapOptionField("maxParallelTrainingJobs", maxParallelTrainingJobs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.HPOResourceConfig
  ) extends zio.aws.personalize.model.HPOResourceConfig.ReadOnly {
    override val maxNumberOfTrainingJobs: Optional[HPOResource] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxNumberOfTrainingJobs())
        .map(value => zio.aws.personalize.model.primitives.HPOResource(value))
    override val maxParallelTrainingJobs: Optional[HPOResource] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxParallelTrainingJobs())
        .map(value => zio.aws.personalize.model.primitives.HPOResource(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.HPOResourceConfig
  ): zio.aws.personalize.model.HPOResourceConfig.ReadOnly = new Wrapper(impl)
}
