package zio.aws.personalize.model
import zio.prelude.data.Optional
import zio.aws.personalize.model.primitives.{MaxResults, NextToken, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListBatchInferenceJobsRequest(
    solutionVersionArn: Optional[Arn] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalize.model.ListBatchInferenceJobsRequest = {
    import ListBatchInferenceJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalize.model.ListBatchInferenceJobsRequest
      .builder()
      .optionallyWith(
        solutionVersionArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.solutionVersionArn)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.personalize.model.ListBatchInferenceJobsRequest.ReadOnly =
    zio.aws.personalize.model.ListBatchInferenceJobsRequest
      .wrap(buildAwsValue())
}
object ListBatchInferenceJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalize.model.ListBatchInferenceJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalize.model.ListBatchInferenceJobsRequest =
      zio.aws.personalize.model.ListBatchInferenceJobsRequest(
        solutionVersionArn.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def solutionVersionArn: Optional[Arn]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getSolutionVersionArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("solutionVersionArn", solutionVersionArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalize.model.ListBatchInferenceJobsRequest
  ) extends zio.aws.personalize.model.ListBatchInferenceJobsRequest.ReadOnly {
    override val solutionVersionArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.solutionVersionArn())
      .map(value => zio.aws.personalize.model.primitives.Arn(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.personalize.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.personalize.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalize.model.ListBatchInferenceJobsRequest
  ): zio.aws.personalize.model.ListBatchInferenceJobsRequest.ReadOnly =
    new Wrapper(impl)
}
